@extends('layouts.admin')

@section('content')
    <!-- Page Header -->
    <div class="py-6 bg-[#F6F6F6] border-b border-[#CBB4B0]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Detail Partner</h1>
                    <p class="text-gray-600 mt-1">{{ $partner->name }}</p>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.partners.index') }}" 
                       class="bg-[#8B8B8B] text-white px-4 py-2 rounded-none hover:bg-[#192D50] transition duration-150">
                        Kembali
                    </a>
                    <a href="{{ route('admin.partners.edit', $partner) }}" 
                       class="bg-[#192D50] text-white px-4 py-2 rounded-none hover:bg-[#8B8B8B] transition duration-150">
                        Edit
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 bg-[#F6F6F6]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Partner Information -->
                <div class="lg:col-span-2">
                    <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none mb-8 border border-[#CBB4B0]">
                        <div class="p-6">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Partner</h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <p class="text-sm text-gray-600">Nama Partner</p>
                                    <p class="font-medium text-gray-900">{{ $partner->name }}</p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-600">Kode Partner</p>
                                    <p class="font-medium text-gray-900">{{ $partner->code }}</p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-600">Email</p>
                                    <p class="font-medium text-gray-900">{{ $partner->email }}</p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-600">Telepon</p>
                                    <p class="font-medium text-gray-900">{{ $partner->phone }}</p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-600">Contact Person</p>
                                    <p class="font-medium text-gray-900">{{ $partner->contact_person }}</p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-600">Status</p>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                        @if($partner->status == 'active') bg-[#8B8B8B] text-white
                                        @else bg-[#192D50] text-white @endif">
                                        {{ ucfirst($partner->status) }}
                                    </span>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-600">Password Partner</p>
                                    <div class="flex items-center space-x-2">
                                        <p class="font-medium text-gray-900" id="partner-password">{{ $partner->password_plain ?? 'Belum ada' }}</p>
                                        @if($partner->password_plain)
                                        <button type="button" onclick="togglePartnerPassword()" 
                                                class="text-[#8B8B8B] hover:text-[#CBB4B0] text-sm font-medium">
                                            <span id="toggle-partner-text">Sembunyikan</span>
                                        </button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="mt-6">
                                <p class="text-sm text-gray-600">Alamat</p>
                                <p class="font-medium text-gray-900">{{ $partner->address }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Exam Results -->
                    <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                        <div class="p-6">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Hasil Pemeriksaan ({{ $partner->examResults->count() }})</h3>
                            
                            @if($partner->examResults->count() > 0)
                                <div class="space-y-4">
                                    @foreach($partner->examResults as $result)
                                        <div class="border border-gray-200 rounded-none p-4">
                                            <div class="flex justify-between items-start">
                                                <div class="flex-1">
                                                    <h4 class="font-medium text-gray-900">{{ ucfirst($result->exam_type) }}</h4>
                                                    
                                                    @if($result->patient)
                                                        <p class="text-sm text-gray-600">Pasien: {{ $result->patient->name }}</p>
                                                        <p class="text-sm text-gray-600">MRN: {{ $result->patient->mrn ?? 'Belum ada' }}</p>
                                                    @elseif($result->employee)
                                                        <p class="text-sm text-gray-600">Karyawan: {{ $result->employee->name }}</p>
                                                        <p class="text-sm text-gray-600">Perusahaan: {{ $result->employee->company->name ?? 'N/A' }}</p>
                                                        <p class="text-sm text-gray-600">Nomor Karyawan: {{ $result->employee->employee_number }}</p>
                                                    @elseif($result->partner)
                                                        <p class="text-sm text-gray-600">Rekanan: {{ $result->partner->name }}</p>
                                                        <p class="text-sm text-gray-600">Kode: {{ $result->partner->code }}</p>
                                                    @else
                                                        <p class="text-sm text-gray-600">Subjek: Tidak Diketahui</p>
                                                    @endif
                                                    
                                                    <p class="text-sm text-gray-600">Tanggal: {{ $result->exam_date->format('d F Y') }}</p>
                                                    @if($result->notes)
                                                        <p class="text-sm text-gray-600 mt-1">{{ $result->notes }}</p>
                                                    @endif
                                                </div>
                                                <div class="flex items-center space-x-2">
                                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                                        @if($result->status == 'completed') bg-[#8B8B8B] text-white
                                                        @elseif($result->status == 'pending') bg-[#192D50] text-white
                                                        @else bg-[#192D50] text-white @endif">
                                                        {{ ucfirst($result->status) }}
                                                    </span>
                                                    @if($result->result_file_path)
                                                        <a href="{{ route('admin.exam-results.show', $result) }}" 
                                                           class="text-[#CBB4B0] hover:text-[#8B8B8B] text-sm">
                                                            Lihat Detail
                                                        </a>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="text-center py-8">
                                    <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-gray-100 mb-4">
                                        <svg class="h-6 w-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                    </div>
                                    <h3 class="text-lg font-medium text-gray-900 mb-2">Belum Ada Hasil</h3>
                                    <p class="text-gray-600">Belum ada hasil pemeriksaan yang terhubung dengan partner ini.</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Actions Sidebar -->
                <div class="lg:col-span-1">
                    <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none mb-8 border border-[#CBB4B0]">
                        <div class="p-6">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Aksi</h3>
                            <div class="space-y-3">
                                <a href="{{ route('admin.partners.edit', $partner) }}" 
                                   class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-none text-white bg-[#192D50] hover:bg-[#8B8B8B] transition duration-150">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                    </svg>
                                    Edit Partner
                                </a>
                                
                                <form method="POST" action="{{ route('admin.partners.toggle-status', $partner) }}">
                                    @csrf
                                    <button type="submit" 
                                            class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-none text-white bg-[#8B8B8B] hover:bg-[#192D50] transition duration-150"
                                            onclick="return confirm('Yakin ingin mengubah status partner ini?')">
                                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"></path>
                                        </svg>
                                        {{ $partner->status == 'active' ? 'Nonaktifkan' : 'Aktifkan' }}
                                    </button>
                                </form>
                                
                                <form method="POST" action="{{ route('admin.partners.reset-password', $partner) }}">
                                    @csrf
                                    <button type="submit" 
                                            class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-none text-white bg-[#192D50] hover:bg-[#8B8B8B] transition duration-150"
                                            onclick="return confirm('Yakin ingin reset password partner ini?')">
                                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z"></path>
                                        </svg>
                                        Reset Password
                                    </button>
                                </form>
                                
                                <form method="POST" action="{{ route('admin.partners.destroy', $partner) }}">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                            class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-none text-white bg-[#192D50] hover:bg-[#8B8B8B] transition duration-150"
                                            onclick="return confirm('Yakin ingin menghapus partner ini? Tindakan ini tidak dapat dibatalkan.')">
                                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                        </svg>
                                        Hapus Partner
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Statistics -->
                    <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                        <div class="p-6">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Statistik</h3>
                            <div class="space-y-4">
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Total Hasil Pemeriksaan</span>
                                    <span class="font-medium text-gray-900">{{ $partner->examResults->count() }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Status Partner</span>
                                    <span class="font-medium text-gray-900">{{ ucfirst($partner->status) }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Dibuat</span>
                                    <span class="font-medium text-gray-900">{{ $partner->created_at->format('d M Y') }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
function togglePartnerPassword() {
    const passwordElement = document.getElementById('partner-password');
    const toggleText = document.getElementById('toggle-partner-text');
    
    if (passwordElement.textContent === '••••••••') {
        passwordElement.textContent = '{{ $partner->password_plain ?? "Belum ada" }}';
        toggleText.textContent = 'Sembunyikan';
    } else {
        passwordElement.textContent = '••••••••';
        toggleText.textContent = 'Tampilkan';
    }
}
</script>
@endpush
